/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.unlock;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.Prefs;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.helpers.SaveHelper;
import com.megacrit.cardcrawl.steam.SteamSaveSync;
import com.megacrit.cardcrawl.unlock.AbstractUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad1.HeavyBladeUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad1.LimitBreakUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad1.SpotWeaknessUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad2.EvolveUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad2.ImmolateUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad2.WildStrikeUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad3.ExhumeUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad3.HavocUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad3.SentinelUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad4.CarnageUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad4.EntrenchUnlock;
import com.megacrit.cardcrawl.unlock.cards.Ironclad4.GhostlyArmorUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent1.BaneUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent1.CatalystUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent1.CorpseExplosionUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent2.ReflexUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent2.TacticianUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent2.UnderhandedStrikeUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent3.AccuracyUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent3.CloakAndDaggerUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent3.StormOfSteelUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent4.ConcentrateUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent4.GrandFinaleUnlock;
import com.megacrit.cardcrawl.unlock.cards.Silent4.SetupUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic1.OmamoriUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic1.PrayerWheelUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic1.ShovelUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic2.ArtOfWarUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic2.CourierUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic2.PandorasBoxUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic3.BlueCandleUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic3.DeadBranchUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic3.SingingBowlUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic4.DuvuDollUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic4.SmilingMaskUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic4.TinyChestUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic5.CalipersUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic5.PhilosophersStoneUnlock;
import com.megacrit.cardcrawl.unlock.relics.relic5.RunicDomeUnlock;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnlockTracker {
    private static final Logger logger = LogManager.getLogger(UnlockTracker.class.getName());
    public static Prefs unlockPref;
    public static Prefs seenPref;
    public static Prefs bossSeenPref;
    public static Prefs relicSeenPref;
    public static Prefs achievementPref;
    public static Prefs unlockProgress;
    public static HashMap<String, String> unlockReqs;
    public static ArrayList<String> lockedCards;
    public static ArrayList<String> lockedCharacters;
    public static ArrayList<String> lockedLoadouts;
    public static ArrayList<String> lockedRelics;
    public static HashMap<String, AbstractUnlock> cardUnlocks;
    public static HashMap<String, AbstractUnlock> relicUnlocks;
    public static int lockedRedCardCount;
    public static int unlockedRedCardCount;
    public static int lockedGreenCardCount;
    public static int unlockedGreenCardCount;
    public static int seenRedCardCount;
    public static int seenGreenCardCount;
    public static int seenBlueCardCount;
    public static int lockedRelicCount;
    public static int unlockedRelicCount;
    private static final int STARTING_UNLOCK_COST = 300;

    public static void initialize() {
        achievementPref = SaveHelper.getPrefs("STSAchievements");
        unlockPref = SaveHelper.getPrefs("STSUnlocks");
        unlockProgress = SaveHelper.getPrefs("STSUnlockProgress");
        seenPref = SaveHelper.getPrefs("STSSeenCards");
        bossSeenPref = SaveHelper.getPrefs("STSSeenBosses");
        relicSeenPref = SaveHelper.getPrefs("STSSeenRelics");
        UnlockTracker.refresh();
    }

    public static void retroactiveUnlock() {
        ArrayList<AbstractUnlock> list;
        int lvl;
        logger.info("Retroactive Unlocks: ");
        AbstractPlayer.PlayerClass c = AbstractPlayer.PlayerClass.IRONCLAD;
        logger.info(c.toString() + " unlock level: " + lvl);
        for (lvl = unlockProgress.getInteger(new StringBuilder().append(c.toString()).append("UnlockLevel").toString(), 0); lvl != 0; --lvl) {
            list = UnlockTracker.getUnlockBundle(c, lvl - 1);
            for (AbstractUnlock u : list) {
                UnlockTracker.hardUnlockOverride(u.key);
            }
        }
        c = AbstractPlayer.PlayerClass.THE_SILENT;
        logger.info(c.toString() + " unlock level: " + lvl);
        for (lvl = unlockProgress.getInteger(new StringBuilder().append(c.toString()).append("UnlockLevel").toString(), 0); lvl != 0; --lvl) {
            list = UnlockTracker.getUnlockBundle(c, lvl - 1);
            for (AbstractUnlock u : list) {
                UnlockTracker.hardUnlockOverride(u.key);
            }
        }
    }

    public static void refresh() {
        lockedCards.clear();
        lockedCharacters.clear();
        lockedLoadouts.clear();
        lockedRelics.clear();
        UnlockTracker.addCard("Ghostly Armor");
        UnlockTracker.addCard("Carnage");
        UnlockTracker.addCard("Entrench");
        UnlockTracker.addCard("Havoc");
        UnlockTracker.addCard("Sentinel");
        UnlockTracker.addCard("Exhume");
        UnlockTracker.addCard("Wild Strike");
        UnlockTracker.addCard("Evolve");
        UnlockTracker.addCard("Immolate");
        UnlockTracker.addCard("Heavy Blade");
        UnlockTracker.addCard("Spot Weakness");
        UnlockTracker.addCard("Limit Break");
        UnlockTracker.addCard("Concentrate");
        UnlockTracker.addCard("Setup");
        UnlockTracker.addCard("Grand Finale");
        UnlockTracker.addCard("Cloak And Dagger");
        UnlockTracker.addCard("Accuracy");
        UnlockTracker.addCard("Storm of Steel");
        UnlockTracker.addCard("Underhanded Strike");
        UnlockTracker.addCard("Reflex");
        UnlockTracker.addCard("Tactician");
        UnlockTracker.addCard("Bane");
        UnlockTracker.addCard("Catalyst");
        UnlockTracker.addCard("Corpse Explosion");
        UnlockTracker.addCharacter("The Silent");
        UnlockTracker.addRelic("Omamori");
        UnlockTracker.addRelic("Prayer Wheel");
        UnlockTracker.addRelic("Shovel");
        UnlockTracker.addRelic("Art of War");
        UnlockTracker.addRelic("The Courier");
        UnlockTracker.addRelic("Pandora's Box");
        UnlockTracker.addRelic("Blue Candle");
        UnlockTracker.addRelic("Dead Branch");
        UnlockTracker.addRelic("Singing Bowl");
        UnlockTracker.addRelic("Du-Vu Doll");
        UnlockTracker.addRelic("Smiling Mask");
        UnlockTracker.addRelic("Tiny Chest");
        UnlockTracker.countUnlockedCards();
    }

    public static int incrementUnlockRamp(int currentCost) {
        switch (currentCost) {
            case 300: {
                return 750;
            }
            case 500: {
                return 1000;
            }
            case 750: {
                return 1000;
            }
            case 1000: {
                return 1500;
            }
            case 1500: {
                return 2000;
            }
            case 2000: {
                return 2500;
            }
            case 2500: {
                return 3000;
            }
            case 3000: {
                return 3000;
            }
            case 4000: {
                return 4000;
            }
        }
        return currentCost + 250;
    }

    public static void resetUnlockProgress(AbstractPlayer.PlayerClass c) {
        unlockProgress.putInteger(c.toString() + "UnlockLevel", 0);
        unlockProgress.putInteger(c.toString() + "Progress", 0);
        unlockProgress.putInteger(c.toString() + "CurrentCost", 300);
        unlockProgress.putInteger(c.toString() + "TotalScore", 0);
        unlockProgress.putInteger(c.toString() + "HighScore", 0);
    }

    public static int getUnlockLevel(AbstractPlayer.PlayerClass c) {
        return unlockProgress.getInteger(c.toString() + "UnlockLevel", 0);
    }

    public static int getCurrentProgress(AbstractPlayer.PlayerClass c) {
        return unlockProgress.getInteger(c.toString() + "Progress", 0);
    }

    public static int getCurrentScoreCost(AbstractPlayer.PlayerClass c) {
        return unlockProgress.getInteger(c.toString() + "CurrentCost", 300);
    }

    public static int getCurrentScoreTotal(AbstractPlayer.PlayerClass c) {
        return unlockProgress.getInteger(c.toString() + "TotalScore", 0);
    }

    public static int getHighscore(AbstractPlayer.PlayerClass c) {
        return unlockProgress.getInteger(c.toString() + "HighScore", 0);
    }

    public static void addScore(AbstractPlayer.PlayerClass c, int scoreGained) {
        String key_unlock_level = c.toString() + "UnlockLevel";
        String key_progress = c.toString() + "Progress";
        String key_current_cost = c.toString() + "CurrentCost";
        String key_total_score = c.toString() + "TotalScore";
        String key_high_score = c.toString() + "HighScore";
        logger.info("Keys");
        logger.info(key_unlock_level);
        logger.info(key_progress);
        logger.info(key_current_cost);
        logger.info(key_total_score);
        logger.info(key_high_score);
        int p = unlockProgress.getInteger(key_progress, 0);
        if ((p += scoreGained) >= unlockProgress.getInteger(key_current_cost, 300)) {
            logger.info("[DEBUG] Level up!");
            int lvl = unlockProgress.getInteger(key_unlock_level, 0);
            unlockProgress.putInteger(key_unlock_level, ++lvl);
            unlockProgress.putInteger(key_progress, p -= unlockProgress.getInteger(key_current_cost, 300));
            logger.info("[DEBUG] Score Progress: " + key_progress);
            int current_cost = unlockProgress.getInteger(key_current_cost, 300);
            unlockProgress.putInteger(key_current_cost, UnlockTracker.incrementUnlockRamp(current_cost));
            if (p > unlockProgress.getInteger(key_current_cost, 300)) {
                unlockProgress.putInteger(key_progress, unlockProgress.getInteger(key_current_cost, 300) - 1);
                logger.info("Overfloat maxes out next level");
            }
        } else {
            unlockProgress.putInteger(key_progress, p);
        }
        int total = unlockProgress.getInteger(key_total_score, 0);
        unlockProgress.putInteger(key_total_score, total += scoreGained);
        logger.info("[DEBUG] Total score: " + total);
        int highscore = unlockProgress.getInteger(key_high_score, 0);
        if (scoreGained > highscore) {
            unlockProgress.putInteger(key_high_score, scoreGained);
            logger.info("[DEBUG] New high score: " + scoreGained);
        }
        unlockProgress.flush();
    }

    public static void countUnlockedCards() {
        ArrayList<String> tmp = new ArrayList<String>();
        int count = 0;
        tmp.add("Ghostly Armor");
        tmp.add("Carnage");
        tmp.add("Entrench");
        tmp.add("Havoc");
        tmp.add("Sentinel");
        tmp.add("Exhume");
        tmp.add("Wild Strike");
        tmp.add("Evolve");
        tmp.add("Immolate");
        tmp.add("Heavy Blade");
        tmp.add("Spot Weakness");
        tmp.add("Limit Break");
        for (String s : tmp) {
            if (UnlockTracker.isCardLocked(s)) continue;
            ++count;
        }
        lockedRedCardCount = tmp.size();
        unlockedRedCardCount = count;
        tmp.clear();
        count = 0;
        tmp.add("Concentrate");
        tmp.add("Setup");
        tmp.add("Grand Finale");
        tmp.add("Cloak And Dagger");
        tmp.add("Accuracy");
        tmp.add("Storm of Steel");
        tmp.add("Underhanded Strike");
        tmp.add("Reflex");
        tmp.add("Tactician");
        tmp.add("Bane");
        tmp.add("Catalyst");
        tmp.add("Corpse Explosion");
        for (String s : tmp) {
            if (UnlockTracker.isCardLocked(s)) continue;
            ++count;
        }
        lockedGreenCardCount = tmp.size();
        unlockedGreenCardCount = count;
        tmp.clear();
        count = 0;
        tmp.add("Omamori");
        tmp.add("Prayer Wheel");
        tmp.add("Shovel");
        tmp.add("Art of War");
        tmp.add("The Courier");
        tmp.add("Pandora's Box");
        tmp.add("Blue Candle");
        tmp.add("Dead Branch");
        tmp.add("Singing Bowl");
        tmp.add("Du-Vu Doll");
        tmp.add("Smiling Mask");
        tmp.add("Tiny Chest");
        for (String s : tmp) {
            if (UnlockTracker.isRelicLocked(s)) continue;
            ++count;
        }
        lockedRelicCount = tmp.size();
        unlockedRelicCount = count;
        logger.info("RED UNLOCKS:   " + unlockedRedCardCount + "/" + lockedRedCardCount);
        logger.info("GREEN UNLOCKS: " + unlockedGreenCardCount + "/" + lockedGreenCardCount);
        logger.info("RELIC UNLOCKS: " + unlockedRelicCount + "/" + lockedRelicCount);
        logger.info("CARDS SEEN:    " + seenPref.get().keySet().size() + "/" + CardLibrary.totalCardCount);
        logger.info("RELICS SEEN:   " + relicSeenPref.get().keySet().size() + "/" + RelicLibrary.totalRelicCount);
    }

    public static String getCardsSeenString() {
        return seenPref.get().keySet().size() + "/" + CardLibrary.totalCardCount;
    }

    public static String getRelicsSeenString() {
        return relicSeenPref.get().keySet().size() + "/" + RelicLibrary.totalRelicCount;
    }

    public static void addCard(String key) {
        if (unlockPref.getString(key).equals("true")) {
            unlockPref.putInteger(key, 2);
            logger.info("Converting " + key + " from bool to int");
            unlockPref.flush();
        } else if (unlockPref.getString(key).equals("false")) {
            unlockPref.putInteger(key, 0);
            logger.info("Converting " + key + " from bool to int");
            unlockPref.flush();
        }
        if (unlockPref.getInteger(key, 0) != 2) {
            lockedCards.add(key);
        }
    }

    public static void addCharacter(String key) {
        if (unlockPref.getString(key).equals("true")) {
            unlockPref.putInteger(key, 2);
            logger.info("Converting " + key + " from bool to int");
            unlockPref.flush();
        } else if (unlockPref.getString(key).equals("false")) {
            unlockPref.putInteger(key, 0);
            logger.info("Converting " + key + " from bool to int");
            unlockPref.flush();
        }
        if (unlockPref.getInteger(key, 0) != 2) {
            lockedCharacters.add(key);
        }
    }

    public static void addRelic(String key) {
        if (unlockPref.getInteger(key, 0) != 2) {
            lockedRelics.add(key);
        }
    }

    public static void unlockAchievement(String key) {
        if (Settings.isShowBuild) {
            return;
        }
        SteamSaveSync.unlockAchievement(key);
        if (!achievementPref.getBoolean(key, false)) {
            achievementPref.putBoolean(key, true);
            achievementPref.flush();
            logger.info("Achievement Unlocked: " + key);
        }
    }

    public static void hardUnlock(String key) {
        if (Settings.isShowBuild) {
            return;
        }
        if (unlockPref.getInteger(key, 0) == 1) {
            unlockPref.putInteger(key, 2);
            unlockPref.flush();
            logger.info("Hard Unlock: " + key);
        }
    }

    public static void hardUnlockOverride(String key) {
        if (Settings.isShowBuild) {
            return;
        }
        unlockPref.putInteger(key, 2);
        unlockPref.flush();
        logger.info("Hard Unlock: " + key);
    }

    public static boolean isCardLocked(String key) {
        return lockedCards.contains(key);
    }

    public static void unlockCard(String key) {
        seenPref.putInteger(key, 1);
        seenPref.flush();
        unlockPref.putInteger(key, 2);
        unlockPref.flush();
        lockedCards.remove(key);
        if (CardLibrary.getCard(key) != null) {
            CardLibrary.getCard((String)key).isSeen = true;
            CardLibrary.getCard(key).unlock();
        }
    }

    public static boolean isCharacterLocked(String key) {
        if ((key.equals("The Silent") || key.equals("Crowbot")) && Settings.isDemo) {
            return false;
        }
        return lockedCharacters.contains(key);
    }

    public static boolean isHardModeLocked() {
        return unlockPref.getInteger("WIZARD", 0) != 2;
    }

    public static boolean isRelicLocked(String key) {
        return lockedRelics.contains(key);
    }

    public static void markCardAsSeen(String key) {
        seenPref.putInteger(key, 1);
        seenPref.flush();
        if (CardLibrary.getCard(key) != null) {
            CardLibrary.getCard((String)key).isSeen = true;
        }
    }

    public static boolean isCardSeen(String key) {
        return seenPref.getInteger(key, 0) != 0;
    }

    public static void markRelicAsSeen(String key) {
        relicSeenPref.putInteger(key, 1);
        relicSeenPref.flush();
        RelicLibrary.getRelic((String)key).isSeen = true;
    }

    public static boolean isRelicSeen(String key) {
        return relicSeenPref.getInteger(key, 0) == 1;
    }

    public static void markBossAsSeen(String originalName) {
        bossSeenPref.putInteger(originalName, 1);
        bossSeenPref.flush();
    }

    public static boolean isBossSeen(String key) {
        return bossSeenPref.getInteger(key, 0) == 1;
    }

    public static ArrayList<AbstractUnlock> getUnlockBundle(AbstractPlayer.PlayerClass c, int unlockLevel) {
        ArrayList<AbstractUnlock> tmpBundle = new ArrayList<AbstractUnlock>();
        block0 : switch (c) {
            case IRONCLAD: {
                switch (unlockLevel) {
                    case 0: {
                        tmpBundle.add(new HeavyBladeUnlock());
                        tmpBundle.add(new SpotWeaknessUnlock());
                        tmpBundle.add(new LimitBreakUnlock());
                        break block0;
                    }
                    case 1: {
                        tmpBundle.add(new OmamoriUnlock());
                        tmpBundle.add(new PrayerWheelUnlock());
                        tmpBundle.add(new ShovelUnlock());
                        break block0;
                    }
                    case 2: {
                        tmpBundle.add(new WildStrikeUnlock());
                        tmpBundle.add(new EvolveUnlock());
                        tmpBundle.add(new ImmolateUnlock());
                        break block0;
                    }
                    case 3: {
                        tmpBundle.add(new HavocUnlock());
                        tmpBundle.add(new SentinelUnlock());
                        tmpBundle.add(new ExhumeUnlock());
                        break block0;
                    }
                    case 4: {
                        tmpBundle.add(new BlueCandleUnlock());
                        tmpBundle.add(new DeadBranchUnlock());
                        tmpBundle.add(new SingingBowlUnlock());
                        break block0;
                    }
                    case 5: {
                        tmpBundle.add(new GhostlyArmorUnlock());
                        tmpBundle.add(new CarnageUnlock());
                        tmpBundle.add(new EntrenchUnlock());
                        break block0;
                    }
                }
                break;
            }
            case THE_SILENT: {
                switch (unlockLevel) {
                    case 0: {
                        tmpBundle.add(new BaneUnlock());
                        tmpBundle.add(new CatalystUnlock());
                        tmpBundle.add(new CorpseExplosionUnlock());
                        break block0;
                    }
                    case 1: {
                        tmpBundle.add(new DuvuDollUnlock());
                        tmpBundle.add(new SmilingMaskUnlock());
                        tmpBundle.add(new TinyChestUnlock());
                        break block0;
                    }
                    case 2: {
                        tmpBundle.add(new UnderhandedStrikeUnlock());
                        tmpBundle.add(new ReflexUnlock());
                        tmpBundle.add(new TacticianUnlock());
                        break block0;
                    }
                    case 3: {
                        tmpBundle.add(new CloakAndDaggerUnlock());
                        tmpBundle.add(new AccuracyUnlock());
                        tmpBundle.add(new StormOfSteelUnlock());
                        break block0;
                    }
                    case 4: {
                        tmpBundle.add(new ArtOfWarUnlock());
                        tmpBundle.add(new CourierUnlock());
                        tmpBundle.add(new PandorasBoxUnlock());
                        break block0;
                    }
                    case 5: {
                        tmpBundle.add(new ConcentrateUnlock());
                        tmpBundle.add(new SetupUnlock());
                        tmpBundle.add(new GrandFinaleUnlock());
                        break block0;
                    }
                }
                break;
            }
            case CROWBOT: {
                switch (unlockLevel) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        tmpBundle.add(new CalipersUnlock());
                        tmpBundle.add(new PhilosophersStoneUnlock());
                        tmpBundle.add(new RunicDomeUnlock());
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                }
                break;
            }
        }
        return tmpBundle;
    }

    public static void addCardUnlockToList(HashMap<String, AbstractUnlock> map, String key, AbstractUnlock unlock) {
        if (UnlockTracker.isCardLocked(key)) {
            map.put(key, unlock);
        }
    }

    public static void addRelicUnlockToList(HashMap<String, AbstractUnlock> map, String key, AbstractUnlock unlock) {
        if (UnlockTracker.isRelicLocked(key)) {
            map.put(key, unlock);
        }
    }

    static {
        unlockReqs = new HashMap();
        lockedCards = new ArrayList();
        lockedCharacters = new ArrayList();
        lockedLoadouts = new ArrayList();
        lockedRelics = new ArrayList();
        cardUnlocks = new HashMap();
        relicUnlocks = new HashMap();
    }
}

